using System;
using System.Collections.Generic;

class Program
{
    struct TestCase
    {
        public int N; 
        public int Q;
    }

    static void Main()
    {
        var tLine = Console.ReadLine();
        while (string.IsNullOrWhiteSpace(tLine)) 
        {
            tLine = Console.ReadLine();
            if (tLine == null)

                return;
        }
        int t;
        if (!int.TryParse(tLine, out t))
        {

            return;
        }
        List<TestCase> testCases = new List<TestCase>();
        for (int i = 0; i < t; i++)
        {

            var line = Console.ReadLine();
            while (string.IsNullOrWhiteSpace(line))
            {
                line = Console.ReadLine();
                if (line == null)
                {
                    break;
                }
            }
            if (line == null)
            { break; }

            var parts =
            line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);

            if (parts.Length < 2)
            {
                i--;

                continue;
            }

            TestCase tc = new TestCase();
            tc.N = int.Parse(parts[0]);
            tc.Q = int.Parse(parts[1]);
            testCases.Add(tc);
        }
        foreach (var tc in testCases)
        {
            if (tc.N != tc.Q)
            {
                Console.WriteLine("-1");
            }
            else
            {
                PronadjiMatrice(tc.N);
            }
        }
    }
    static void PronadjiMatrice(int n)
    {
        int[,] mat = new int[n, n];
        for (int i = n - 1; i >= 0; i--)
        {
            int rowTargetDivisor = i + 1;
            long currentSum = 0;
            for
            (int j = i + 1; j < n; j++)
            {

                currentSum += mat[i, j];
            }

            long remainder = currentSum % rowTargetDivisor;
            long needed = (remainder == 0) ? 0 : (rowTargetDivisor - remainder);

            if (currentSum == 0 &&
            needed == 0)
            {
                needed = rowTargetDivisor;
            }

            for (int k = 0; k < needed;
            k++)
            {
                int col = i - k;
                if (col < 0)
                {
                    break;
                }

                mat[i, col] = 1; mat[col, i] = 1;
            }
        }
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < n; j++)
            {
                Console.Write(mat[i, j]);
                if (j < n - 1)
                { Console.Write(" "); }
            }

            Console.WriteLine();
        }
    }
}